<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

/**
* @uses _dropdown.php
* @uses _dropdown_field.php
* @uses _label.php
*
* @package icarus
* @subpackage form-markup-generator
*/
class Dropdown_markup_generator extends Field_markup_generator{
	protected $_type = 'dropdown';
	protected $_options;
	protected $_security_validation_method = 'isValidString';
	protected $_security_sanitization_method = 'sanitizeString'; 
	
	function selected_option_description(){
		if(!isset($this->value)) return '';
		return $this->options[$this->value];
	}
		
	function set_value($value){
		if(is_string($value) && empty($value) && !array_key_exists($value, $this->options)) return;
		
		parent::set_value($value);
		if(!array_key_exists($this->raw_value, $this->_options) && !$this->raw_value ==''){
			$this->error->property_value_should_be_a_key_in_the_options_array('value', $this, $this->raw_value);
		}
	}
	
	/**
	*
	* Checks to see if it's been passed an array of numbers.  If so, converts them to strings
	* because values from $_POST will always be strings and we need to be able to check to see if the value
	* is in the options array.
	*
	*/
	function set_options($options){
		if(!$this->validator->is_an_array($options)) return $this->error->should_be_an_array_of_strings($options);
		
		//if we were pass an array of numbers, convert them to strings so we can convert them to the $_POST values properly
		if(!$this->validator->is_an_array_of_strings($options) && $this->validator->is_an_array_of_numerics($options)){
			foreach($options as $key => $value){
				$options[$key] = (string)$value;
			}
		}
				
		if(!$this->validator->is_an_array_of_strings($options)) 
			return $this->error->should_be_an_array_of_strings($options);

		$this->_options = $options;
	}
	
	
	function options(){
		if(isset($this->_options)) return $this->_options;
		return array();		
	}
	
	/**
	* Overrides parent to check to see if the value is included in this dropdown's {@link _options}.
	*/
	protected function has_valid_value_if_any(){
		if(!isset($this->options)) return $this->error->warning("I can't validate the value of the ".$this->name." field when no options are set.");
		if(!isset($this->property)) return true;
		return array_key_exists($this->value, $this->options);
	}
	
}